#!/usr/bin/python

eastEnd = ['Shalestorm Shingle', 'Sable Strand', 'Shattered Shack']
ymax = 3
xmax = 6

print "[This section was autogenerated by makesea.py. Ideally, changes to this section should be made by changing and rerunning that script, then pasting the results in here.]\n"

def dirmark(x, y):
    if x >= 1 and y >= 1 and x <= xmax and y <= ymax:
        return "Sea%d%d" % (x, y)
    if y < 1 or y > ymax:
        return None
    if x == 0:
        return eastEnd[y-1]
    return None

def dirparts (x, y):
    name = dirmark(x, y)
    result = "Sea%d%d is " % (x, y)
    if y != 1:
        result += "southwest of %s, south of %s, " % (dirmark(x-1, y-1), dirmark(x, y-1))
        if y == ymax:
            result += "and "
    result += "west of %s" % (dirmark(x-1, y))
    if y != ymax:
        if y != 1:
            result += ","
        result += " and northwest of %s" % (dirmark(x-1, y+1))
    result += "."
    print result    

def printroom (x, y):
    name = dirmark(x, y)
    print "%s is a sea-room. The x-coordinate of %s is %d." % (name, name, x)
    dirparts (x, y)
    if y == 1 or y == ymax: print ("The force field is in %s." % name),
    print "The distant tower is in %s. The distant island is in %s. The ocean below is in %s.\n" % (name, name, name)

for i in range(xmax):
    for j in range(ymax):
        printroom(i+1, j+1)
